/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractAjaxBehavior
extends Behavior
implements IRequestListener {
    private static final long serialVersionUID = 1L;
    private Component component;

    @Override
    public final void bind(Component hostComponent) {
        Args.notNull(hostComponent, "hostComponent");
        if (this.component != null) {
            throw new IllegalStateException("this kind of handler cannot be attached to multiple components; it is already attached to component " + String.valueOf(this.component) + ", but component " + String.valueOf(hostComponent) + " wants to be attached too");
        }
        this.component = hostComponent;
        this.onBind();
    }

    public CharSequence getCallbackUrl() {
        Component component = this.getComponent();
        if (component == null) {
            throw new IllegalArgumentException("Behavior must be bound to a component to create the URL");
        }
        PageParameters parameters = new PageParameters();
        PageParameters pageParameters = component.getPage().getPageParameters();
        List<INamedParameters.NamedPair> allNamedInPath = pageParameters.getAllNamedByType(INamedParameters.Type.PATH);
        for (INamedParameters.NamedPair namedPair : allNamedInPath) {
            parameters.add(namedPair.getKey(), namedPair.getValue(), INamedParameters.Type.PATH);
        }
        return this.getComponent().urlForListener(this, parameters);
    }

    @Override
    public final void onComponentTag(Component component, ComponentTag tag) {
        this.onComponentTag(tag);
    }

    @Override
    public final void afterRender(Component hostComponent) {
        this.onComponentRendered();
    }

    public final Component getComponent() {
        return this.component;
    }

    protected void onComponentTag(ComponentTag tag) {
    }

    protected void onBind() {
    }

    protected void onComponentRendered() {
    }

    @Override
    public final void unbind(Component component) {
        this.onUnbind();
        this.component = null;
        super.unbind(component);
    }

    protected void onUnbind() {
    }
}

