/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.hotspot;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public class ClassLoadingExports
extends Collector {
    private final ClassLoadingMXBean clBean;

    public ClassLoadingExports() {
        this(ManagementFactory.getClassLoadingMXBean());
    }

    public ClassLoadingExports(ClassLoadingMXBean clBean) {
        this.clBean = clBean;
    }

    void addClassLoadingMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily("jvm_classes_loaded", "The number of classes that are currently loaded in the JVM", (double)this.clBean.getLoadedClassCount()));
        sampleFamilies.add((Collector.MetricFamilySamples)new CounterMetricFamily("jvm_classes_loaded_total", "The total number of classes that have been loaded since the JVM has started execution", (double)this.clBean.getTotalLoadedClassCount()));
        sampleFamilies.add((Collector.MetricFamilySamples)new CounterMetricFamily("jvm_classes_unloaded_total", "The total number of classes that have been unloaded since the JVM has started execution", (double)this.clBean.getUnloadedClassCount()));
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addClassLoadingMetrics(mfs);
        return mfs;
    }
}

